#!bin/sh

#
# @(#)src/resources/updateSettings.sh, webstart, pxia32w1420, 20040616 1.1
# ===========================================================================
# Licensed Materials - Property of IBM
# "Restricted Materials of IBM"
#
# IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
# (C) Copyright IBM Corp. 1998, 2003. All Rights Reserved
# ===========================================================================
#

#


#
# For updating ~/.mailcap and ~/.mime.types .

javahome=/opt/IBMJava2-142
JAVAWS_BIN=jre/javaws/javaws
MIME_TYPE=application/x-java-jnlp-file

if [ -n "$JAVAWS_BIN" -a -z "$JAVAWS_PRIVATE" ]; then
  FULLJAVAHOME=`cd $javahome 2> /dev/null; pwd` 
if [ -z "${FULLJAVAHOME}" ]; then
	echo "Could not find IBM Java.."
        exit 0
else 
  if [ -w ${HOME}/.mailcap ]; then
    jGrep=`grep -n ${MIME_TYPE} ${HOME}/.mailcap`
    if [ -n "$jGrep" ] ; then
      grep -v ${MIME_TYPE} < ${HOME}/.mailcap | grep -v "# Java Web Start" > /tmp/.mailcap1
      mv /tmp/.mailcap1 ${HOME}/.mailcap
    fi
    # Doesn't contain application/x-java-jnlp-file file, add it.
    echo "# Java Web Start" >> ${HOME}/.mailcap
    echo "${MIME_TYPE}; $FULLJAVAHOME/$JAVAWS_BIN %s" >> ${HOME}/.mailcap
  elif [ -w ${HOME}/ ]; then
    # .mailcap doesn't exist, create it.
    echo "# Java Web Start" > ${HOME}/.mailcap
    echo "${MIME_TYPE}; $FULLJAVAHOME/$JAVAWS_BIN %s" >> ${HOME}/.mailcap
  fi
  if [ -w ${HOME}/.mime.types ]; then
    # the file exists, make sure it contains jnlp
    jGrep=`grep ${MIME_TYPE} ${HOME}/.mime.types`
    if [ -z "${jGrep}" ]; then
      # doesn't contain Javaws, add it
      echo "type=${MIME_TYPE} desc=\"Java Web Start\" exts=\"jnlp\"" >> ${HOME}/.mime.types
    fi
  elif [ -w ${HOME}/ ]; then
    # Doesn't exist so create it, even though if it doesn't exist it
    # implies you are not using Communicator, but we'll create it on the
    # chance that you do install Communicator.
    echo '#--Netscape Communications Corporation MIME Information' > ${HOME}/.mime.types
    echo '#Do not delete the above line. It is used to identify the file type.' >> ${HOME}/.mime.types
    echo '#mime types added by Netscape Helper' >> ${HOME}/.mime.types
    echo 'type=application/x-java-jnlp-file desc="Java Web Start" exts="jnlp"' >> ${HOME}/.mime.types
   fi
# Update the mime types for Mozilla ( if exists ) - ibm@51028,ibm@52266
   if [ -d "${HOME}/.mozilla" ]; then
  	touch ${HOME}/temp_file
  	TEMP_FILE=${HOME}/temp_file
  	echo "<?xml version=\"1.0\"?>" > ${TEMP_FILE}
  	echo "<RDF xmlns:RDF=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"" >> ${TEMP_FILE}
  	echo "     xmlns:NC=\"http://home.netscape.com/NC-rdf#\">" >> ${TEMP_FILE}
  	echo "  <RDF:Description about=\"urn:mimetype:handler:application/x-java-jnlp-file\"" >> ${TEMP_FILE}
  	echo "                 NC:saveToDisk=\"false\"" >> ${TEMP_FILE}
  	echo "                 NC:handleInternal=\"false\"" >> ${TEMP_FILE}
  	echo "                 NC:alwaysAsk=\"true\">" >> ${TEMP_FILE}
  	echo "  <NC:externalApplication resource=\"urn:mimetype:externalApplication:application/x-java-jnlp-file\"/>" >> ${TEMP_FILE}
  	echo "  </RDF:Description>" >> ${TEMP_FILE}
  	echo "  <RDF:Description about=\"urn:mimetype:externalApplication:application/x-java-jnlp-file\"" >> ${TEMP_FILE}
  	echo "                 NC:path=\"${javahome}/${JAVAWS_BIN}\"" >> ${TEMP_FILE}
  	echo "                 NC:prettyName=\"javaws\" />" >> ${TEMP_FILE}
  	echo "  <RDF:Description about=\"urn:mimetype:application/x-java-jnlp-file\"" >> ${TEMP_FILE}
  	echo "                 NC:value=\"application/x-java-jnlp-file\"" >> ${TEMP_FILE}
  	echo "                 NC:description=\"Java Web Start\"" >> ${TEMP_FILE}
  	echo "                 NC:fileExtensions=\"jnlp\"" >> ${TEMP_FILE}
  	echo "                 NC:editable=\"true\">" >> ${TEMP_FILE}
  	echo "  <NC:handlerProp resource=\"urn:mimetype:handler:application/x-java-jnlp-file\"/>" >> ${TEMP_FILE}
  	echo "  </RDF:Description>" >> ${TEMP_FILE}
  	echo "  <RDF:Seq about=\"urn:mimetypes:root\">" >> ${TEMP_FILE}
  	echo "    <RDF:li resource=\"urn:mimetype:application/x-java-jnlp-file\"/>" >> ${TEMP_FILE}
  	echo "  </RDF:Seq>" >> ${TEMP_FILE}
  	# Append the existing list of mime types to the new file
  	# Check for the existing profile and update accodingly - ibm@52453
  	if [ -d ${HOME}/.mozilla/default ]; then
      		tail +4 ${HOME}/.mozilla/default/*.slt/mimeTypes.rdf >> ${TEMP_FILE}
      		cp ${HOME}/temp_file ${HOME}/.mozilla/default/*.slt/mimeTypes.rdf
  	fi
  	if [ -d ${HOME}/.mozilla/${LOGNAME} ]; then
       	        tail +4 ${HOME}/.mozilla/${LOGNAME}/*.slt/mimeTypes.rdf >> ${TEMP_FILE}
       		cp ${HOME}/temp_file ${HOME}/.mozilla/${LOGNAME}/*.slt/mimeTypes.rdf
  	fi
     	rm ${HOME}/temp_file
      fi
 fi 
fi
